#!/bin/sh

if [ "$#" -ne 1 ]; then
  echo "Please specify path"
  exit 1
fi

path="$1"
cd $path
echo "Fixing symlinks in $path"

find . -type l ! -exec test -e {} \; -print0 | while read -d $'\0' file
do
  link_target=`readlink $file`
  link_target_path="./$link_target"
  link_directory=`dirname $file`/

  if  [[ $link_target_path == $link_directory* ]] ;
  then
    fixed_target=${link_target_path/$link_directory/}
    echo "Fixing link target from $link_target to $fixed_target"
    ln -hfs "$fixed_target" "$file"
  fi
done